#!/usr/bin/env bash

prover="--pubkey=${CUSTOM_TEMPLATE} --name=${HOSTNAME}"

if [[ -z "${CUSTOM_PASS}" ]]; then
    conf="--pubkey=${CUSTOM_TEMPLATE} --name=${HOSTNAME}"
else
    conf="--proxy=${CUSTOM_PASS}:9999 --name=${HOSTNAME}"
    echo -e "\e[33m[+] Proxy Mode ON\e[0m"
    echo -e "\e[33m \e[0m"
fi

echo -e "\e[33mWallet: ${CUSTOM_TEMPLATE}\e[0m"
echo -e "\e \e[0m"

CPU_CORES=$(nproc)

if [ "$CPU_CORES" -eq 1 ]; then
	THREADS=0
fi

THREADS=$((CPU_CORES - 1))

GPU_COUNT=$(nvidia-smi -L 2>/dev/null | wc -l)


if [ "$GPU_COUNT" -gt 1 ]; then

	if [[ "$CUSTOM_USER_CONFIG" != *"--threads-per-card"* ]]; then
		THREADS=$(( THREADS / GPU_COUNT ))
     

        if [ "$THREADS" -lt 2 ]; then
            THREADS=0
        fi

        if [ "$THREADS" -eq 2 ]; then
            echo -e "\e[33m[!] CPU is insufficient, hashrate will be low.\e[0m"
	fi

        conf+=" --threads-per-card ${THREADS}"
        echo -e "\e[33m[+] CPU Cores: $CPU_CORES, GPUs: $GPU_COUNT, Threads per GPU: $THREADS (auto-calculated)\e[0m"
    
else

	USER_THREADS=$(echo "$CUSTOM_USER_CONFIG" | grep -oP '(?<=--threads-per-card[= ])[0-9]+')
        conf+=" --threads-per-card ${USER_THREADS}"
        echo -e "\e[33m[+] CPU Cores: $CPU_CORES, GPUs: $GPU_COUNT, Threads per GPU: $USER_THREADS (user-defined)\e[0m"
fi

else

	if [[ "$CUSTOM_USER_CONFIG" != *"--threads-per-card"* ]]; then

		if [ "$THREADS" -gt 15 ]; then
			THREADS=15
		fi

		conf+=" --threads-per-card ${THREADS}"
		echo -e "\e[33m[+] CPU Cores: $CPU_CORES, GPUs: $GPU_COUNT, Threads for GPU: $THREADS (auto-calculated)\e[0m"
 
	else
		USER_THREADS=$(echo "$CUSTOM_USER_CONFIG" | grep -oP '(?<=--threads-per-card[= ])[0-9]+')
		conf+=" --threads-per-card ${USER_THREADS}"
		echo -e "\e[33m[+] CPU Cores: $CPU_CORES, GPUs: $GPU_COUNT, Threads for GPU: $USER_THREADS (user-defined)\e[0m"
	fi
fi

if [[ "$CUSTOM_USER_CONFIG" != *"--gpu"* ]]; then
	GPU=ALL
	conf_gpu="--gpu $GPU"
else
	GPU=$(echo "$CUSTOM_USER_CONFIG" | grep -oP '(?<=--gpu[= ])[0-9,]+')
	conf_gpu="--gpu $GPU"
fi

# Create ${CUSTOM_NAME}.conf
echo "$conf_gpu" > $GPU_CONFIG_FILENAME

# Create ${CUSTOM_NAME}.conf
echo "$prover" > $CONFIG_FILENAME

# Create ${CUSTOM_NAME}.conf
echo "$conf" > $CUSTOM_CONFIG_FILENAME
echo -e "\e[33m \e[0m"
