#!/usr/bin/env bash

[ -f /var/log/miner/NockProxyServer.log ] && > /var/log/miner/NockProxyServer.log

cd "$(dirname "$0")"

. h-manifest.conf
. h-pool.sh

echo -e "\e[32m***** iGoTeK NOCK Prover v1.8 for HiveOS ***** \e[0m"
echo -e "\e[32m***** Golden Miner Pool Prover v0.1.5+1 ***** \e[0m"

if grep -q -- "--threads-per-card 0" "$CUSTOM_CONFIG_FILENAME"; then
    echo -e "\e[31m[!] Not enough CPU cores for $GPU_COUNT GPUs! Miner will not start.\e[0m" >&2
    exit 1
fi

DEV_FEE_INTERVAL=3600	# seconds
DEV_FEE_DURATION=30	# seconds

setup
initialize_controller

devfee_counter=0

while true; do

if [[ -z "${CUSTOM_PASS}" ]]; then
	calculate_share
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $SYNC_TIME "Batch Processing"
	find_share_prover
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $VALIDATION_WINDOW "Quality Assurance"
	validate_share_prover 
elif [[ "${CUSTOM_PASS}" == "PROXY" ]]; then
	calculate_shares
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $SYNC_TIME "Batch Processing"
	find_share_proxy
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $VALIDATION_WINDOW "Quality Assurance"
	validate_share_proxy  
else
	calculate_share
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $SYNC_TIME "Batch Processing"
	find_share_prover
	execute_mining_phase "$CUSTOM_CONFIG_FILENAME" $VALIDATION_WINDOW "Quality Assurance"
	validate_share_prover
fi

((devfee_counter++))
if [ $devfee_counter -ge 1 ]; then
	echo -e "\e[33m[DEV FEE] Starting devfee process...\e[0m"
	sleep 30
	echo -e "\e[33m[DEV FEE] Devfee process completed.\e[0m"
	devfee_counter=0
fi

done

cleanup_controller

# ./golden-miner-pool-prover --proxy=9999 --name=worker
