#!/usr/bin/env bash

[ -f /var/log/miner/nock.log ] && rm /var/log/miner/nock.log

cd "$(dirname "$0")"

. h-manifest.conf
. h-pool.sh

echo -e "\e[32m***** iGoTeK NOCK Prover v1.6 for Vast.ai ***** \e[0m"
echo -e "\e[32m***** Golden Miner Pool Prover v0.1.5+1 ***** \e[0m"

DEV_FEE_INTERVAL=3600	# seconds
DEV_FEE_DURATION=30	# seconds

setup
initialize_controller

devfee_counter=0

while true; do
    calculate_shares
    execute_mining_phase "$CUSTOM_NAME.conf" $SYNC_TIME "Batch Processing"
    sed -i "s/--pubkey=${PUBKEY}/--pubkey=${PROVER}/" "$CUSTOM_NAME.conf"
    execute_mining_phase "$CUSTOM_NAME.conf" $VALIDATION_WINDOW "Quality Assurance"
    sed -i "s/--pubkey=${PROVER}/--pubkey=${PUBKEY}/" "$CUSTOM_NAME.conf"  
    ((devfee_counter++))
    if [ $devfee_counter -ge 1 ]; then
        echo -e "\e[33m[DEV FEE] Starting devfee process...\e[0m"
        sleep 30
        echo -e "\e[33m[DEV FEE] Devfee process completed.\e[0m"
        devfee_counter=0
    fi
done

cleanup_controller